/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.v.ValkyriesCallContinuousEffect;
import mage.cards.v.ValkyriesCallCounterEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ValkyriesCallEffect
extends OneShotEffect {
    ValkyriesCallEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return that card to the battlefield under its owner's control with a +1/+1 counter on it. It has flying and is an Angel in addition to its other types";
    }

    private ValkyriesCallEffect(ValkyriesCallEffect effect) {
        super((OneShotEffect)effect);
    }

    public ValkyriesCallEffect copy() {
        return new ValkyriesCallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new ValkyriesCallCounterEffect(card, game), source);
        game.addEffect((ContinuousEffect)new ValkyriesCallContinuousEffect(card, game), source);
        return player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

