/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.MenaceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;

public final class ValleyRotcaller
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent();
    private static final DynamicValue xValue;
    private static final Hint hint;

    public ValleyRotcaller(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{B}");
        this.subtype.add((Object)SubType.SQUIRREL);
        this.subtype.add((Object)SubType.WARLOCK);
        this.power = new MageInt(1);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)new MenaceAbility(false));
        AttacksTriggeredAbility ability = new AttacksTriggeredAbility((Effect)new LoseLifeOpponentsEffect(xValue).setText("each opponent loses X life"));
        ability.addEffect((Effect)new GainLifeEffect(xValue, "and you gain X life, where X is the number of other Squirrels, Bats, Lizards, and Rats you control"));
        this.addAbility(ability.addHint(hint));
    }

    private ValleyRotcaller(ValleyRotcaller card) {
        super((CardImpl)card);
    }

    public ValleyRotcaller copy() {
        return new ValleyRotcaller(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.SQUIRREL.getPredicate(), SubType.BAT.getPredicate(), SubType.LIZARD.getPredicate(), SubType.RAT.getPredicate()}));
        xValue = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Other Squirrels, Bats, Lizards, and Rats you control", xValue);
    }
}

