/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VampirismBoostEnchantedEffect
extends ContinuousEffectImpl {
    VampirismBoostEnchantedEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Enchanted creature gets +1/+1 for each other creature you control";
    }

    private VampirismBoostEnchantedEffect(VampirismBoostEnchantedEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public VampirismBoostEnchantedEffect copy() {
        return new VampirismBoostEnchantedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent enchantment;
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
        int count = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) - 1;
        if (count > 0 && (enchantment = game.getPermanent(source.getSourceId())) != null && enchantment.getAttachedTo() != null && (creature = game.getPermanent(enchantment.getAttachedTo())) != null) {
            creature.addPower(count);
            creature.addToughness(count);
            return true;
        }
        return false;
    }
}

