/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.v.VanishIntoMemoryReturnFromExileEffect;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class VanishIntoMemoryEffect
extends OneShotEffect {
    VanishIntoMemoryEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile target creature. You draw cards equal to that creature's power. At the beginning of your next upkeep, return that card to the battlefield under its owner's control. If you do, discard cards equal to that creature's toughness";
    }

    private VanishIntoMemoryEffect(VanishIntoMemoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && permanent != null && sourceObject != null && controller.moveCardsToExile((Card)permanent, source, game, true, source.getSourceId(), sourceObject.getIdName())) {
            controller.drawCards(permanent.getPower().getValue(), source, game);
            ExileZone exile = game.getExile().getExileZone(source.getSourceId());
            if (exile != null && !exile.isEmpty()) {
                VanishIntoMemoryReturnFromExileEffect effect = new VanishIntoMemoryReturnFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)exile, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility((Effect)effect), source);
            }
            return true;
        }
        return false;
    }

    public VanishIntoMemoryEffect copy() {
        return new VanishIntoMemoryEffect(this);
    }
}

