/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VantressGargoyleBlockEffect
extends RestrictionEffect {
    VantressGargoyleBlockEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't block unless you have four or more cards in hand";
    }

    private VantressGargoyleBlockEffect(VantressGargoyleBlockEffect effect) {
        super((RestrictionEffect)effect);
    }

    public VantressGargoyleBlockEffect copy() {
        return new VantressGargoyleBlockEffect(this);
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.getHand().size() < 4 && permanent.getId().equals(source.getSourceId());
    }
}

