/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VaporousDjinnEffect
extends OneShotEffect {
    VaporousDjinnEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} phases out unless you pay {U}{U}";
    }

    private VaporousDjinnEffect(VaporousDjinnEffect effect) {
        super((OneShotEffect)effect);
    }

    public VaporousDjinnEffect copy() {
        return new VaporousDjinnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ManaCostsImpl cost = new ManaCostsImpl("{U}{U}");
            String message = "Pay {U}{U} to prevent this permanent from phasing out?";
            if (!controller.chooseUse(Outcome.Benefit, message, source, game) || !cost.pay(source, game, source, controller.getId(), false, null)) {
                permanent.phaseOut(game);
            }
            return true;
        }
        return false;
    }
}

