/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;

class Vault112SadisticSimulationChapterEffect
extends OneShotEffect {
    Vault112SadisticSimulationChapterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Pay any amount of {E}. If you paid one or more {E} this way, shuffle your library, then exile that many cards from the top. You may play one of those cards without paying its mana cost.";
    }

    private Vault112SadisticSimulationChapterEffect(Vault112SadisticSimulationChapterEffect effect) {
        super((OneShotEffect)effect);
    }

    public Vault112SadisticSimulationChapterEffect copy() {
        return new Vault112SadisticSimulationChapterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int numberToPay = controller.getAmount(0, controller.getCountersCount(CounterType.ENERGY), "How many {E} do you like to pay?", source, game);
        if (numberToPay <= 0) {
            return true;
        }
        PayEnergyCost cost = new PayEnergyCost(numberToPay);
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return true;
        }
        controller.shuffleLibrary(source, game);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, numberToPay));
        controller.moveCardsToExile(cards.getCards(game), source, game, true, null, "");
        cards.retainZone(Zone.EXILED, game);
        if (cards.isEmpty()) {
            return true;
        }
        TargetCardInExile target = new TargetCardInExile(0, 1, StaticFilters.FILTER_CARD_CARDS);
        controller.choose(Outcome.PlayForFree, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        ActivatedAbility ability = controller.chooseLandOrSpellAbility(card, game, true);
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        if (ability instanceof SpellAbility) {
            controller.cast((SpellAbility)ability, game, true, new ApprovingObject(source, game));
        } else if (ability instanceof PlayLandAbility && controller.canPlayLand()) {
            controller.playLand(card, game, true);
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return true;
    }
}

