/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.common.SagaAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.hint.Hint;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SagaChapter;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class Vault87ForcedEvolution
extends CardImpl {
    private static final FilterCreaturePermanent filterNonMutant = new FilterCreaturePermanent("non-Mutant creature");
    private static final FilterControlledPermanent filterMutant;
    private static final GreatestAmongPermanentsValue xValue;
    private static final Hint hint;

    public Vault87ForcedEvolution(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{G}{U}");
        this.subtype.add((Object)SubType.SAGA);
        SagaAbility sagaAbility = new SagaAbility((Card)this);
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_I, (Effect)new GainControlTargetEffect(Duration.WhileControlled), (Target)new TargetPermanent((FilterPermanent)filterNonMutant));
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_II, new Effects(new Effect[]{new AddCountersTargetEffect(CounterType.P1P1.createInstance()), new AddCardSubTypeTargetEffect(SubType.MUTANT, Duration.Custom).setText("It becomes a Mutant in addition to its other types")}), (Target)new TargetControlledCreaturePermanent());
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_III, new Effect[]{new DrawCardSourceControllerEffect((DynamicValue)xValue).setText("draw cards equal to the greatest power among Mutants you control")});
        this.addAbility(sagaAbility.addHint(hint));
    }

    private Vault87ForcedEvolution(Vault87ForcedEvolution card) {
        super((CardImpl)card);
    }

    public Vault87ForcedEvolution copy() {
        return new Vault87ForcedEvolution(this);
    }

    static {
        filterNonMutant.add(Predicates.not((Predicate)SubType.MUTANT.getPredicate()));
        filterMutant = new FilterControlledPermanent("Mutants you control");
        filterMutant.add((Predicate)SubType.MUTANT.getPredicate());
        xValue = new GreatestAmongPermanentsValue(GreatestAmongPermanentsValue.Quality.Power, (FilterPermanent)filterMutant);
        hint = xValue.getHint();
    }
}

