/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class VelukanDragonEffect
extends OneShotEffect {
    VelukanDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. {this} gets +X/+0 until end of turn, where X is the result minus 1";
    }

    private VelukanDragonEffect(VelukanDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public VelukanDragonEffect copy() {
        return new VelukanDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int roll = player.rollDice(Outcome.BoostCreature, source, game, 6);
        if (roll > 1) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(roll - 1, 0, Duration.EndOfTurn), source);
        }
        return true;
    }
}

