/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class VendilionCliqueEffect
extends OneShotEffect {
    VendilionCliqueEffect() {
        super(Outcome.Discard);
        this.staticText = "look at target player's hand. You may choose a nonland card from it. If you do, that player reveals the chosen card, puts it on the bottom of their library, then draws a card";
    }

    private VendilionCliqueEffect(VendilionCliqueEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player != null && controller != null && sourceObject != null) {
            Card card;
            TargetCard targetCard = new TargetCard(0, 1, Zone.ALL, (FilterCard)new FilterNonlandCard());
            if (controller.choose(Outcome.Discard, player.getHand(), targetCard, source, game) && (card = game.getCard(targetCard.getFirstTarget())) != null) {
                CardsImpl cards = new CardsImpl();
                cards.add(card);
                player.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                player.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
                player.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }

    public VendilionCliqueEffect copy() {
        return new VendilionCliqueEffect(this);
    }
}

