/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceInGraveyardCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.PutOnLibrarySourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedBatchForOnePermanentEvent;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAttackingCreature;

class VengefulPharaohTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedEvent> {
    VengefulPharaohTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new DestroyTargetEffect(), false);
        this.addTarget((Target)new TargetAttackingCreature());
        this.addEffect((Effect)new PutOnLibrarySourceEffect(true).setText(", then put this card on top of your library"));
        this.withInterveningIf((Condition)SourceInGraveyardCondition.instance);
        this.setTriggerPhrase("Whenever combat damage is dealt to you or a planeswalker you control, ");
    }

    private VengefulPharaohTriggeredAbility(VengefulPharaohTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VengefulPharaohTriggeredAbility copy() {
        return new VengefulPharaohTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER && event.getTargetId().equals(this.getControllerId())) {
            DamagedBatchForOnePlayerEvent dEvent = (DamagedBatchForOnePlayerEvent)event;
            return dEvent.isCombatDamage() && dEvent.getAmount() > 0;
        }
        if (event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT) {
            Permanent permanent = game.getPermanent(event.getTargetId());
            DamagedBatchForOnePermanentEvent dEvent = (DamagedBatchForOnePermanentEvent)event;
            return permanent != null && permanent.isPlaneswalker(game) && permanent.isControlledBy(this.getControllerId()) && dEvent.isCombatDamage() && dEvent.getAmount() > 0;
        }
        return false;
    }
}

