/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToBattlefieldEffect;
import mage.cards.v.VengevineWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class VengevineAbility
extends TriggeredAbilityImpl {
    public VengevineAbility() {
        super(Zone.GRAVEYARD, (Effect)new ReturnSourceFromGraveyardToBattlefieldEffect(), true);
    }

    private VengevineAbility(VengevineAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VengevineAbility copy() {
        return new VengevineAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Watcher watcher;
        return event.getPlayerId().equals(this.controllerId) && (watcher = game.getState().getWatcher(VengevineWatcher.class, this.controllerId)) != null && watcher.conditionMet();
    }

    public String getRule() {
        return "Whenever you cast a spell, if it's the second creature spell you cast this turn, you may return {this} from your graveyard to the battlefield.";
    }
}

