/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VentifactBottleEffect
extends OneShotEffect {
    VentifactBottleEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap it and remove all charge counters from it. Add {C} for each charge counter removed this way";
    }

    private VentifactBottleEffect(VentifactBottleEffect effect) {
        super((OneShotEffect)effect);
    }

    public VentifactBottleEffect copy() {
        return new VentifactBottleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || sourcePermanent == null) {
            return false;
        }
        sourcePermanent.tap(source, game);
        int amountRemoved = sourcePermanent.removeAllCounters(CounterType.CHARGE.getName(), source, game);
        if (amountRemoved > 0) {
            player.getManaPool().addMana(Mana.ColorlessMana((int)amountRemoved), game, source);
        }
        return true;
    }
}

