/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.v.VerdantSuccessionEffect;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class VerdantSuccessionTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("green nontoken creature");

    VerdantSuccessionTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private VerdantSuccessionTriggeredAbility(VerdantSuccessionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VerdantSuccessionTriggeredAbility copy() {
        return new VerdantSuccessionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zoneChangeEvent = (ZoneChangeEvent)event;
        if (zoneChangeEvent.isDiesEvent()) {
            Permanent permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD);
            MageObject mageObject = game.getObject(this.sourceId);
            if (permanent != null && mageObject != null && filter.match((Object)permanent, game)) {
                this.getEffects().clear();
                this.addEffect((Effect)new VerdantSuccessionEffect(permanent.getName(), permanent.getControllerId()));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever a green nontoken creature dies, that creature's controller may search their library for a card with the same name as that creature, put it onto the battlefield, then shuffle.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

