/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.DiscardedCardsEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class VeronicaDissidentScribeWatcher
extends Watcher {
    private final Map<UUID, Integer> timesNonlandCardsDiscardedThisTurn = new HashMap<UUID, Integer>();

    VeronicaDissidentScribeWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DISCARDED_CARDS && event.getAmount() > 0) {
            boolean nonlandCardsWereDiscarded;
            DiscardedCardsEvent discardedCardsEvent = (DiscardedCardsEvent)event;
            boolean bl = nonlandCardsWereDiscarded = !discardedCardsEvent.getDiscardedCards().getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game).isEmpty();
            if (nonlandCardsWereDiscarded) {
                this.timesNonlandCardsDiscardedThisTurn.merge(event.getPlayerId(), 1, Integer::sum);
            }
        }
    }

    public void reset() {
        super.reset();
        this.timesNonlandCardsDiscardedThisTurn.clear();
    }

    int numTimesDiscardedNonlandCardThisTurn(UUID playerId) {
        return this.timesNonlandCardsDiscardedThisTurn.getOrDefault(playerId, 0);
    }
}

