/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.stream.Stream;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class VerrakWarpedSengirTriggeredAbility
extends TriggeredAbilityImpl {
    VerrakWarpedSengirTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private VerrakWarpedSengirTriggeredAbility(VerrakWarpedSengirTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VerrakWarpedSengirTriggeredAbility copy() {
        return new VerrakWarpedSengirTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
        if (stackAbility == null || stackAbility.getStackAbility().isManaActivatedAbility()) {
            return false;
        }
        int lifePaid = CardUtil.castStream((Stream)stackAbility.getStackAbility().getCosts().stream(), PayLifeCost.class).mapToInt(PayLifeCost::getLifePaid).sum();
        if (lifePaid > 0) {
            this.getEffects().clear();
            this.addEffect((Effect)new DoIfCostPaid((Effect)new CopyStackObjectEffect(), (Cost)new PayLifeCost(lifePaid)));
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever you activate an ability that isn't a mana ability, if life was paid to activate it, you may pay that much life again. If you do, copy that ability. You may choose new targets for the copy.";
    }
}

