/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class VesselOfTheAllConsumingWatcher
extends Watcher {
    private final Map<Map.Entry<MageObjectReference, UUID>, Integer> morMap = new HashMap<Map.Entry<MageObjectReference, UUID>, Integer>();

    VesselOfTheAllConsumingWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null) {
            int damage = event.getAmount();
            this.morMap.compute(new AbstractMap.SimpleImmutableEntry<MageObjectReference, UUID>(new MageObjectReference((MageObject)permanent, game), event.getTargetId()), (u, i) -> i == null ? damage : Integer.sum(i, damage));
        }
    }

    public void reset() {
        super.reset();
        this.morMap.clear();
    }

    static boolean checkPermanent(Game game, Ability source) {
        Map<Map.Entry<MageObjectReference, UUID>, Integer> morMap = ((VesselOfTheAllConsumingWatcher)game.getState().getWatcher(VesselOfTheAllConsumingWatcher.class)).morMap;
        AbstractMap.SimpleImmutableEntry<MageObjectReference, UUID> key = new AbstractMap.SimpleImmutableEntry<MageObjectReference, UUID>(new MageObjectReference((MageObject)game.getPermanent(source.getSourceId()), game), ((Effect)source.getEffects().get(0)).getTargetPointer().getFirst(game, source));
        return morMap.getOrDefault(key, 0) >= 10;
    }
}

