/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class VeteranExplorerEffect
extends OneShotEffect {
    VeteranExplorerEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player may search their library for up to two basic land cards, put them onto the battlefield, then shuffle";
    }

    private VeteranExplorerEffect(VeteranExplorerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VeteranExplorerEffect copy() {
        return new VeteranExplorerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet<Card> toBattlefield = new HashSet<Card>();
        ArrayList<Player> usingPlayers = new ArrayList<Player>();
        if (controller != null) {
            toBattlefield.addAll(this.chooseAndSearchLibrary(usingPlayers, controller, source, game));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || player.equals(controller)) continue;
                toBattlefield.addAll(this.chooseAndSearchLibrary(usingPlayers, player, source, game));
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
            for (Player player : usingPlayers) {
                if (player == null) continue;
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    private Set<Card> chooseAndSearchLibrary(List<Player> usingPlayers, Player player, Ability source, Game game) {
        HashSet<Card> toBattlefield = new HashSet<Card>();
        if (player.chooseUse(Outcome.PutCardInPlay, "Search your library for up to two basic land cards and put them onto the battlefield?", source, game)) {
            usingPlayers.add(player);
            TargetCardInLibrary target = new TargetCardInLibrary(0, 2, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
            if (player.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
                toBattlefield.addAll(new CardsImpl((Collection)target.getTargets()).getCards(game));
            }
        }
        return toBattlefield;
    }
}

