/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SoldierToken;

class VeteranSoldierEffect
extends OneShotEffect {
    VeteranSoldierEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, create a 1/1 white Soldier creature token that's tapped and attacking that opponent";
    }

    private VeteranSoldierEffect(VeteranSoldierEffect effect) {
        super((OneShotEffect)effect);
    }

    public VeteranSoldierEffect copy() {
        return new VeteranSoldierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId(), true)) {
            if (game.getPlayer(opponentId) == null) continue;
            new SoldierToken().putOntoBattlefield(1, game, source, source.getControllerId(), true, true, opponentId);
        }
        return true;
    }
}

