/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class VexingShusherCantCounterTargetEffect
extends ContinuousRuleModifyingEffectImpl {
    VexingShusherCantCounterTargetEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Target spell can't be countered";
    }

    private VexingShusherCantCounterTargetEffect(VexingShusherCantCounterTargetEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public VexingShusherCantCounterTargetEffect copy() {
        return new VexingShusherCantCounterTargetEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null) {
            return "This spell can't be countered (" + sourceObject.getName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.getTargetPointer().getFirst(game, source));
    }
}

