/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class ViashinoBeyEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public ViashinoBeyEffect() {
        super(Outcome.Benefit);
    }

    private ViashinoBeyEffect(ViashinoBeyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        TargetOpponent targetDefender = new TargetOpponent();
        if (controller != null) {
            game.getBattlefield().getAllActivePermanents(CardType.CREATURE, game).stream().filter(permanent -> filter.match(permanent, source.getControllerId(), source, game)).forEachOrdered(permanent -> {
                if (game.getOpponents(controller.getId()).size() > 1) {
                    controller.choose(Outcome.Benefit, (Target)targetDefender, source, game);
                } else {
                    targetDefender.add((UUID)game.getOpponents(controller.getId()).iterator().next(), game);
                }
                if (permanent.canAttack(targetDefender.getFirstTarget(), game)) {
                    controller.declareAttacker(permanent.getId(), targetDefender.getFirstTarget(), game, false);
                }
            });
        }
        return false;
    }

    public ViashinoBeyEffect copy() {
        return new ViashinoBeyEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

