/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class VictimizeEffect
extends OneShotEffect {
    VictimizeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Choose two target creature cards in your graveyard. Sacrifice a creature. If you do, return the chosen cards to the battlefield tapped";
    }

    private VictimizeEffect(VictimizeEffect effect) {
        super((OneShotEffect)effect);
    }

    public VictimizeEffect copy() {
        return new VictimizeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                game.processAction();
                controller.moveCards(new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source)).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
            return true;
        }
        return false;
    }
}

