/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObjectReference;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedBatchBySourceEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;

class VigorousChargeTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedEvent> {
    private final MageObjectReference mor;

    VigorousChargeTriggeredAbility(MageObjectReference mor) {
        super((Effect)new GainLifeEffect((DynamicValue)SavedDamageValue.MUCH), Duration.EndOfTurn, false, false);
        this.mor = mor;
    }

    private VigorousChargeTriggeredAbility(VigorousChargeTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public VigorousChargeTriggeredAbility copy() {
        return new VigorousChargeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_BY_SOURCE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.mor.refersTo(event.getSourceId(), game) || !((DamagedBatchBySourceEvent)event).isCombatDamage()) {
            return false;
        }
        this.getEffects().setValue("damage", (Object)event.getAmount());
        return true;
    }

    public String getRule() {
        return "Whenever that creature deals combat damage this turn, if this spell was kicked, you gain life equal to that damage.";
    }
}

