/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class VineGeckoWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    VineGeckoWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && StaticFilters.FILTER_SPELL_KICKED_A.match((Object)spell, game)) {
            this.playerSet.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    public boolean checkPlayer(UUID playerId) {
        return this.playerSet.contains(playerId);
    }
}

