/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ViselingEffect
extends OneShotEffect {
    ViselingEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to that player, where X is the number of cards in their hand minus 4";
    }

    private ViselingEffect(ViselingEffect effect) {
        super((OneShotEffect)effect);
    }

    public ViselingEffect copy() {
        return new ViselingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent != null) {
            int xValue = opponent.getHand().size() - 4;
            if (xValue > 0) {
                opponent.damage(xValue, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

