/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class VisionsOfBeyondEffect
extends OneShotEffect {
    VisionsOfBeyondEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw a card. If a graveyard has twenty or more cards in it, draw three cards instead";
    }

    private VisionsOfBeyondEffect(VisionsOfBeyondEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        int count = 1;
        for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getGraveyard().size() < 20) continue;
            count = 3;
            break;
        }
        sourcePlayer.drawCards(count, source, game);
        return true;
    }

    public VisionsOfBeyondEffect copy() {
        return new VisionsOfBeyondEffect(this);
    }
}

