/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VisionsOfBrutalityEffect
extends OneShotEffect {
    VisionsOfBrutalityEffect() {
        super(Outcome.Benefit);
        this.staticText = "its controller loses that much life";
    }

    private VisionsOfBrutalityEffect(VisionsOfBrutalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public VisionsOfBrutalityEffect copy() {
        return new VisionsOfBrutalityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int damage;
        Player controllerEnchanted;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (controller == null || enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent enchanted = game.getPermanentOrLKIBattlefield(enchantment.getAttachedTo());
        if (enchanted != null && (controllerEnchanted = game.getPlayer(enchanted.getControllerId())) != null && (damage = ((Integer)this.getValue("damage")).intValue()) > 0) {
            controllerEnchanted.loseLife(damage, game, source, false);
        }
        return true;
    }
}

