/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class VisionsOfRuinEffect
extends OneShotEffect {
    VisionsOfRuinEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent sacrifices an artifact. For each artifact sacrificed this way, you create a Treasure token";
    }

    private VisionsOfRuinEffect(VisionsOfRuinEffect effect) {
        super((OneShotEffect)effect);
    }

    public VisionsOfRuinEffect copy() {
        return new VisionsOfRuinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT, playerId, source, game) < 1) continue;
            TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT);
            target.withNotTarget(true);
            opponent.choose(Outcome.Sacrifice, (Target)target, source, game);
            permanents.add(game.getPermanent(target.getFirstTarget()));
        }
        int sacrificed = 0;
        for (Permanent permanent : permanents) {
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++sacrificed;
        }
        if (sacrificed > 0) {
            new TreasureToken().putOntoBattlefield(sacrificed, game, source, source.getControllerId());
        }
        return true;
    }
}

