/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VislorTurloughGoadEffect
extends GoadTargetEffect {
    private final UUID controllerId;

    VislorTurloughGoadEffect(UUID controllerId, Permanent permanent, Game game) {
        super(Duration.Custom);
        this.controllerId = controllerId;
        this.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
    }

    private VislorTurloughGoadEffect(VislorTurloughGoadEffect effect) {
        super((GoadTargetEffect)effect);
        this.controllerId = effect.controllerId;
    }

    public VislorTurloughGoadEffect copy() {
        return new VislorTurloughGoadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && permanent.isControlledBy(this.controllerId)) {
            return super.apply(game, source);
        }
        this.discard();
        return false;
    }
}

