/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class VivienChampionOfTheWildsCastFromExileEffect
extends AsThoughEffectImpl {
    private final UUID authorizedPlayerId;

    VivienChampionOfTheWildsCastFromExileEffect(UUID authorizedPlayerId) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.authorizedPlayerId = authorizedPlayerId;
    }

    private VivienChampionOfTheWildsCastFromExileEffect(VivienChampionOfTheWildsCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.authorizedPlayerId = effect.authorizedPlayerId;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public VivienChampionOfTheWildsCastFromExileEffect copy() {
        return new VivienChampionOfTheWildsCastFromExileEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UUID cardId = this.getTargetPointer().getFirst(game, source);
        if (cardId == null) {
            this.discard();
        } else if (objectId.equals(cardId) && affectedControllerId.equals(this.authorizedPlayerId)) {
            Card card = game.getCard(objectId);
            return card != null && !card.isLand(game);
        }
        return false;
    }
}

