/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetSacrifice;

class VivienOnTheHuntSacrificeEffect
extends OneShotEffect {
    VivienOnTheHuntSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice a creature. If you do, search your library for a creature card with mana value equal to 1 plus the sacrificed creature's mana value, put it onto the battlefield, then shuffle";
    }

    private VivienOnTheHuntSacrificeEffect(VivienOnTheHuntSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public VivienOnTheHuntSacrificeEffect copy() {
        return new VivienOnTheHuntSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        int mv = permanent.getManaValue() + 1;
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + mv);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, mv));
        TargetCardInLibrary targetCardInLibrary = new TargetCardInLibrary((FilterCard)filter);
        player.searchLibrary(targetCardInLibrary, source, game);
        Card card = player.getLibrary().getCard(targetCardInLibrary.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

