/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

class VizierOfTheMenagerieManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    public VizierOfTheMenagerieManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You can spend mana of any type to cast creature spells";
    }

    private VizierOfTheMenagerieManaEffect(VizierOfTheMenagerieManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public VizierOfTheMenagerieManaEffect copy() {
        return new VizierOfTheMenagerieManaEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        objectId = CardUtil.getMainCardId((Game)game, (UUID)objectId);
        if (source.isControlledBy(affectedControllerId)) {
            MageObject mageObject = game.getObject(objectId);
            return mageObject != null && mageObject.isCreature(game);
        }
        return false;
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

