/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class VoiceOfManyEffect
extends OneShotEffect {
    VoiceOfManyEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card for each opponent who controls fewer creatures than you";
    }

    private VoiceOfManyEffect(VoiceOfManyEffect effect) {
        super((OneShotEffect)effect);
    }

    public VoiceOfManyEffect copy() {
        return new VoiceOfManyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int myCount = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game).size();
        int toDraw = game.getOpponents(source.getControllerId(), true).stream().mapToInt(uuid -> game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, uuid, game).size() < myCount ? 1 : 0).sum();
        if (toDraw == 0) {
            return true;
        }
        return new DrawCardSourceControllerEffect(toDraw).apply(game, source);
    }
}

