/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class VoidstoneGargoyleRuleModifyingEffect2
extends ContinuousRuleModifyingEffectImpl {
    public VoidstoneGargoyleRuleModifyingEffect2() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Activated abilities of sources with the chosen name can't be activated";
    }

    private VoidstoneGargoyleRuleModifyingEffect2(VoidstoneGargoyleRuleModifyingEffect2 effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public VoidstoneGargoyleRuleModifyingEffect2 copy() {
        return new VoidstoneGargoyleRuleModifyingEffect2(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't activate abilities of sources with that name (" + mageObject.getName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        return CardUtil.haveSameNames((MageObject)object, (String)cardName, (Game)game);
    }
}

