/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VolatileClawsEffect
extends ContinuousEffectImpl {
    VolatileClawsEffect() {
        super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "and gain all creature types";
    }

    private VolatileClawsEffect(VolatileClawsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public VolatileClawsEffect copy() {
        return new VolatileClawsEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (Permanent perm : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, source.getControllerId(), source, game)) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)perm, game));
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent == null) {
                it.remove();
                continue;
            }
            permanent.setIsAllCreatureTypes(game, true);
        }
        return true;
    }
}

