/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayTargetControllerEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInLibrary;

public final class VolatileFault
extends CardImpl {
    private static final FilterPermanent filter = new FilterLandPermanent("nonbasic land an opponent controls");

    public VolatileFault(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.subtype.add((Object)SubType.CAVE);
        this.addAbility((Ability)new ColorlessManaAbility());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new DestroyTargetEffect(), (Cost)new GenericManaCost(1));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeSourceCost());
        ability.addEffect((Effect)new SearchLibraryPutInPlayTargetControllerEffect(new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), false, Outcome.PutLandInPlay, "that player"));
        ability.addTarget((Target)new TargetPermanent(filter));
        ability.addEffect((Effect)new CreateTokenEffect((Token)new TreasureToken()).concatBy("you"));
        this.addAbility((Ability)ability);
    }

    private VolatileFault(VolatileFault card) {
        super((CardImpl)card);
    }

    public VolatileFault copy() {
        return new VolatileFault(this);
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

