/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.util.CardUtil;

class VolcanicSalvoCostReductionEffect
extends CostModificationEffectImpl {
    VolcanicSalvoCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "This spell costs {X} less to cast, where X is the total power of creatures you control";
    }

    private VolcanicSalvoCostReductionEffect(VolcanicSalvoCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int reductionAmount = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game).stream().map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.max(0, reductionAmount));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId()) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public VolcanicSalvoCostReductionEffect copy() {
        return new VolcanicSalvoCostReductionEffect(this);
    }
}

