/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class VonasHungerEffect
extends OneShotEffect {
    VonasHungerEffect() {
        super(Outcome.Sacrifice);
    }

    private VonasHungerEffect(VonasHungerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VonasHungerEffect copy() {
        return new VonasHungerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList perms = new ArrayList();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            TargetSacrifice target;
            int numTargets;
            Player player = game.getPlayer(playerId);
            if (player == null || (numTargets = (game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), game) + 1) / 2) <= 0 || !(target = new TargetSacrifice(numTargets, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE)).canChoose(player.getId(), source, game)) continue;
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            perms.addAll(target.getTargets());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

