/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VraskaSchemingGorgonTriggeredAbility
extends TriggeredAbilityImpl {
    VraskaSchemingGorgonTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.setTriggerPhrase("Whenever this creature deals damage to an opponent, ");
    }

    private VraskaSchemingGorgonTriggeredAbility(VraskaSchemingGorgonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VraskaSchemingGorgonTriggeredAbility copy() {
        return new VraskaSchemingGorgonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.getSourceId()) || !((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        if (!game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        this.getAllEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        return true;
    }
}

