/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.token.TreasureAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VraskaTheSilencerContinuousEffect
extends ContinuousEffectImpl {
    private final MageObjectReference mor;
    private static final Ability ability = new TreasureAbility(false);

    VraskaTheSilencerContinuousEffect(MageObjectReference mor) {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "It's a Treasure artifact and loses all other card types.";
        this.mor = mor;
        this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
    }

    private VraskaTheSilencerContinuousEffect(VraskaTheSilencerContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public VraskaTheSilencerContinuousEffect copy() {
        return new VraskaTheSilencerContinuousEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.add(this.mor);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.setIsAllCreatureTypes(game, false);
                permanent.retainAllArtifactSubTypes(game);
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                permanent.addSubType(game, new SubType[]{SubType.TREASURE});
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility(ability, source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }
}

