/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.v.VraskaTheSilencerContinuousEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class VraskaTheSilencerEffect
extends OneShotEffect {
    VraskaTheSilencerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return that card to the battlefield tapped under your control. It's a Treasure artifact with \"{T}, Sacrifice this artifact: Add one mana of any color,\" and it loses all other card types.";
    }

    private VraskaTheSilencerEffect(VraskaTheSilencerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VraskaTheSilencerEffect copy() {
        return new VraskaTheSilencerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        VraskaTheSilencerContinuousEffect continuousEffect = new VraskaTheSilencerContinuousEffect(new MageObjectReference((MageObject)card, game, 1));
        game.addEffect((ContinuousEffect)continuousEffect, source);
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        return true;
    }
}

