/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VraskasStoneglareEffect
extends OneShotEffect {
    VraskasStoneglareEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy target creature. You gain life equal to its toughness";
    }

    private VraskasStoneglareEffect(VraskasStoneglareEffect effect) {
        super((OneShotEffect)effect);
    }

    public VraskasStoneglareEffect copy() {
        return new VraskasStoneglareEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        int toughness = permanent.getToughness().getValue();
        permanent.destroy(source, game, false);
        if (player != null) {
            player.gainLife(toughness, game, source);
        }
        return true;
    }
}

