/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.HasteGolemToken;

class VulshokFactoryEffect
extends OneShotEffect {
    private final DynamicValue xValue;

    VulshokFactoryEffect(DynamicValue xValue) {
        super(Outcome.Benefit);
        this.staticText = "create an X/X colorless Golem artifact creature token with haste, where X is the number of charge counters on {this}";
        this.xValue = xValue;
    }

    private VulshokFactoryEffect(VulshokFactoryEffect effect) {
        super((OneShotEffect)effect);
        this.xValue = effect.xValue;
    }

    public VulshokFactoryEffect copy() {
        return new VulshokFactoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HasteGolemToken token = new HasteGolemToken(this.xValue.calculate(game, source, (Effect)this));
        return token.putOntoBattlefield(1, game, source);
    }
}

