/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.Filter;
import mage.filter.FilterObject;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ProtectionChosenColorTargetEffect
extends ContinuousEffectImpl {
    protected ObjectColor chosenColor;
    protected ProtectionAbility protectionAbility;

    public ProtectionChosenColorTargetEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
    }

    private ProtectionChosenColorTargetEffect(ProtectionChosenColorTargetEffect effect) {
        super((ContinuousEffectImpl)effect);
        if (effect.chosenColor != null) {
            this.chosenColor = effect.chosenColor.copy();
        }
        if (effect.protectionAbility != null) {
            this.protectionAbility = effect.protectionAbility.copy();
        }
    }

    public ProtectionChosenColorTargetEffect copy() {
        return new ProtectionChosenColorTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            ObjectColor color = (ObjectColor)game.getState().getValue(permanent.getId() + "_color");
            if (!(color == null || this.protectionAbility != null && color.equals((Object)this.chosenColor))) {
                this.chosenColor = color;
                FilterObject protectionFilter = new FilterObject(this.chosenColor.getDescription());
                protectionFilter.add((Predicate)new ColorPredicate(this.chosenColor));
                this.protectionAbility = new ProtectionAbility((Filter)protectionFilter);
            }
            if (this.protectionAbility != null) {
                permanent.addAbility((Ability)this.protectionAbility, source.getSourceId(), game);
                return true;
            }
        }
        return false;
    }
}

