/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTopXMayPlayUntilEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class WaltzOfRageTriggeredAbility
extends DelayedTriggeredAbility {
    WaltzOfRageTriggeredAbility() {
        super((Effect)new ExileTopXMayPlayUntilEffect(1, Duration.UntilEndOfYourNextTurn), Duration.EndOfTurn, false, false);
    }

    private WaltzOfRageTriggeredAbility(WaltzOfRageTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public WaltzOfRageTriggeredAbility copy() {
        return new WaltzOfRageTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent()) {
            return false;
        }
        Permanent permanent = zEvent.getTarget();
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }

    public String getRule() {
        return "Until end of turn, whenever a creature you control dies, exile the top card of your library. You may play it until the end of your next turn.";
    }
}

