/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class WarCadenceReplacementEffect
extends ReplacementEffectImpl {
    DynamicValue xCosts = GetXValue.instance;

    WarCadenceReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "This turn, creatures can't block unless their controller pays {X} for each blocking creature they control";
    }

    private WarCadenceReplacementEffect(WarCadenceReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int amount;
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null && (amount = this.xCosts.calculate(game, source, (Effect)this)) > 0) {
            String mana = "{" + amount + '}';
            ManaCostsImpl cost = new ManaCostsImpl(mana);
            return !cost.canPay(source, source, event.getPlayerId(), game) || !player.chooseUse(Outcome.Benefit, "Pay " + mana + " to declare blocker?", source, game) || !cost.payOrRollback(source, game, source, event.getPlayerId());
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARE_BLOCKER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public WarCadenceReplacementEffect copy() {
        return new WarCadenceReplacementEffect(this);
    }
}

