/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WarTaxCantAttackUnlessPaysEffect
extends PayCostToAttackBlockEffectImpl {
    DynamicValue xCosts = GetXValue.instance;

    WarTaxCantAttackUnlessPaysEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral, PayCostToAttackBlockEffectImpl.RestrictType.ATTACK);
        this.staticText = "This turn, creatures can't attack unless their controller pays {X} for each attacking creature they control";
    }

    private WarTaxCantAttackUnlessPaysEffect(WarTaxCantAttackUnlessPaysEffect effect) {
        super((PayCostToAttackBlockEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject != null) {
            int amount = this.xCosts.calculate(game, source, (Effect)this);
            return new ManaCostsImpl("{" + amount + '}');
        }
        return null;
    }

    public boolean isCostless(GameEvent event, Ability source, Game game) {
        return false;
    }

    public WarTaxCantAttackUnlessPaysEffect copy() {
        return new WarTaxCantAttackUnlessPaysEffect(this);
    }
}

