/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterObject;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WardSliverGainAbilityControlledEffect
extends ContinuousEffectImpl {
    protected FilterObject<MageObject> protectionFilter;

    public WardSliverGainAbilityControlledEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "all Slivers have protection from the chosen color";
    }

    private WardSliverGainAbilityControlledEffect(WardSliverGainAbilityControlledEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.protectionFilter = effect.protectionFilter;
    }

    public WardSliverGainAbilityControlledEffect copy() {
        return new WardSliverGainAbilityControlledEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ObjectColor color;
        Permanent permanent;
        if (this.protectionFilter == null && (permanent = game.getPermanent(source.getSourceId())) != null && (color = (ObjectColor)game.getState().getValue(permanent.getId() + "_color")) != null) {
            this.protectionFilter = new FilterObject(color.getDescription());
            this.protectionFilter.add((Predicate)new ColorPredicate(color));
        }
        if (this.protectionFilter != null) {
            for (Permanent perm : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ALL_SLIVERS, source.getControllerId(), source, game)) {
                perm.addAbility((Ability)new ProtectionAbility(this.protectionFilter), source.getSourceId(), game);
            }
            return true;
        }
        return false;
    }
}

