/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WardscaleDragonRuleEffect
extends ContinuousRuleModifyingEffectImpl {
    WardscaleDragonRuleEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, true, false);
        this.staticText = "As long as {this} is attacking, defending player can't cast spells";
    }

    private WardscaleDragonRuleEffect(WardscaleDragonRuleEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public WardscaleDragonRuleEffect copy() {
        return new WardscaleDragonRuleEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && sourcePermanent.isAttacking()) {
            return event.getPlayerId().equals(game.getCombat().getDefendingPlayerId(sourcePermanent.getId(), game, false));
        }
        return false;
    }
}

