/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class WarrenPilferersReturnEffect
extends OneShotEffect {
    WarrenPilferersReturnEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "return target creature card from your graveyard to your hand. If that card is a Goblin card, {this} gains haste until end of turn";
    }

    private WarrenPilferersReturnEffect(WarrenPilferersReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public WarrenPilferersReturnEffect copy() {
        return new WarrenPilferersReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (card != null && controller != null && controller.moveCards(card, Zone.HAND, source, game)) {
            if (card.hasSubtype(SubType.GOBLIN, game)) {
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

